% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rad_oli.R
\name{rad_oli}
\alias{rad_oli}
\title{Radiance Landsat OLI}
\usage{
rad_oli(x)
}
\arguments{
\item{x}{A raster stack containing the first seven Landsat OLI bands.}
}
\value{
A raster layer object with the Top of atmosphere spectral radiance.
}
\description{
This function Convert Digital Numbers to TOA Radiance using the radiance rescaling factors in the MTL file.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
x <- stack(list.files(path_files,".tif", full.names=TRUE))
rad_oli(x)

}
\references{
\url{https://www.usgs.gov/land-resources/nli/landsat/using-usgs-landsat-level-1-data-product}.
}
