% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{util_report_get_data_errors}
\alias{util_report_get_data_errors}
\title{Report errors encountered during \code{nhl_get_data}}
\usage{
util_report_get_data_errors(x, reporter = log_e, ...)
}
\arguments{
\item{x}{\code{list}, results created by \code{\link[=nhl_get_data]{nhl_get_data()}}.}

\item{reporter}{\code{function}, used to report the constructed
error message, e.g. \code{message}, \code{warning}, \code{writeLines},
etc.}

\item{...}{further arguments passed to \code{reporter}, e.g.
\code{con = file("~/log.txt")} in case \code{writeLines} is the
\code{reporter}.}
}
\value{
\code{character()}, URLs for which the retrieval
resulted in an error, invisibly. Optional side-effects.
}
\description{
Report errors encountered during \code{nhl_get_data}
}
\examples{
\dontrun{
  # Write errors to a temporary text file
  tmpFile <- tempfile()
  util_report_get_data_errors(
    nhl_get_data(nhl_url_players(c("none", "8451101", "some"))),
    reporter = writeLines,
    con = tmpFile
  )
}

}
