% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_nfl.R
\name{gt_nfl_logos}
\alias{gt_nfl_logos}
\alias{gt_nfl_wordmarks}
\title{Render Logos and Wordmarks in 'gt' Tables}
\usage{
gt_nfl_logos(gt_object, columns, height = 30, locations = NULL)

gt_nfl_wordmarks(gt_object, columns, height = 30, locations = NULL)
}
\arguments{
\item{gt_object}{A table object that is created using the \code{\link[gt:gt]{gt::gt()}} function.}

\item{columns}{The columns for which the image translation should be applied.
Argument has no effect if \code{locations} is not \code{NULL}.}

\item{height}{The absolute height (px) of the image in the table cell.}

\item{locations}{If \code{NULL} (the default), the function will render
logos/wordmarks in argument \code{columns}.
Otherwise, the cell or set of cells to be associated with the team name
transformation. Only the \code{\link[gt:cells_body]{gt::cells_body()}}, \code{\link[gt:cells_stub]{gt::cells_stub()}},
\code{\link[gt:cells_column_labels]{gt::cells_column_labels()}}, and \code{\link[gt:cells_row_groups]{gt::cells_row_groups()}} helper functions
can be used here. We can enclose several of these calls within a \code{list()}
if we wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Translate NFL team abbreviations into logos and wordmarks and
render these images in html tables with the 'gt' package.
}
\section{Output of below example}{

\if{html}{\figure{logo_tbl.png}{options: width=75\%}}
}

\examples{
\donttest{
library(gt)
library(nflplotR)
teams <- valid_team_names()
# remove conference logos from this example
teams <- teams[!teams \%in\% c("AFC", "NFC", "NFL")]
# create dataframe with all 32 team names
df <- data.frame(
  team_a = head(teams, 16),
  logo_a = head(teams, 16),
  wordmark_a = head(teams, 16),
  team_b = tail(teams, 16),
  logo_b = tail(teams, 16),
  wordmark_b = tail(teams, 16)
)
# create gt table and translate team names to logo/wordmark images
table <- df \%>\%
  gt() \%>\%
  gt_nfl_logos(columns = gt::starts_with("logo")) \%>\%
  gt_nfl_wordmarks(columns = gt::starts_with("wordmark"))
}
}
\seealso{
The player headshot rendering function \code{\link[=gt_nfl_headshots]{gt_nfl_headshots()}}.
}
