% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CompositionMatrix-class}
\alias{CompositionMatrix-class}
\alias{.CompositionMatrix}
\title{Compositional Matrix}
\description{
An S4 class to represent compositional data.
}
\section{Slots}{

\describe{
\item{\code{totals}}{A \code{\link{numeric}} vector to store the absolute row sums (before
the closure of the compositions).}

\item{\code{groups}}{A \code{\link{factor}} vector to store the group names.}
}}

\note{
This class inherits from \code{\link{matrix}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{CompositionMatrix} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\section{Subset}{

In the code snippets below, \code{x} is a \code{CompositionMatrix} object.
\describe{
\item{\code{x[i, j]}}{Extract parts of a matrix (see \code{\link[=subset]{[}}).}
}
}

\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## codaccess
dim(coda) # Get the matrix dimensions
row(coda) # Get the row indexes
col(coda, as.factor = TRUE) # Get the column indexes
nrow(coda) # Get the number of rows
ncol(coda) # Get the number of columns
dimnames(coda) # Get the dimension names
rownames(coda) <- LETTERS[1:25] # Set the row names
rownames(coda) # Get the rownames
colnames(coda) <- letters[21:25] # Set the column names
colnames(coda) # Get the column names
}
\seealso{
\code{\link[=as_composition]{as_composition()}}

Other classes: 
\code{\link{LogRatio-class}},
\code{\link{LogicalMatrix-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OutlierIndex-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
