% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/images2matrix.R
\name{images2matrix}
\alias{images2matrix}
\title{Transform set of images to matrix}
\usage{
images2matrix(imgs, mask = NULL)
}
\arguments{
\item{imgs}{Vector of files or list of images (niftiImage, array, or nifti)}

\item{mask}{Binary image to subset the voxels}
}
\value{
Matrix of V by p, where V is the product of the dimensions of one 
image or the number of voxels in the mask, and p is the number of images
}
\description{
Creates a matrix, where the voxels are on the rows 
and images are on the columns
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rpois(prod(dims), lambda = 2), dim = dims)
nim = oro.nifti::nifti(arr)
imgs = list(nim, arr)
mask = nim > 2
mat1 = images2matrix(imgs)
mat2 = images2matrix(list(nim, nim))
if (packageVersion("oro.nifti") >= package_version("0.10.2")) {
testthat::expect_equal(mat1, mat2)
} else {
testthat::expect_error(testthat::expect_equal(mat1, mat2))
}
mat1 = images2matrix(imgs, mask = mask)
mat2 = images2matrix(list(nim, nim), mask)
}
