% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.preservation.R
\name{is_preserved}
\alias{is_preserved}
\title{Check preservation}
\usage{
is_preserved(P, scores)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{scores}{Numeric vector containing the scores of a centrality index.}
}
\value{
Logical scaler whether \code{scores} preserves the relations in \code{P}.
}
\description{
Checks if a partial ranking is preserved in the ranking induced by \code{scores}.
}
\details{
In order for a score vector to preserve a partial ranking, the following
condition must be fulfilled:
\code{P[u,v]==1 & scores[i]<=scores[j]}.
}
\examples{

library(igraph)
# standard measures of centrality preserve the neighborhood inclusion preorder
g <- graph.empty(n=11,directed = FALSE)
g <- add_edges(g,c(1,11,2,4,3,5,3,11,4,8,5,9,5,11,6,7,6,8,
                   6,10,6,11,7,9,7,10,7,11,8,9,8,10,9,10))
P<-neighborhood_inclusion(g)

is_preserved(P,degree(g))
is_preserved(P,betweenness(g))
is_preserved(P,closeness(g))
}
\author{
David Schoch
}
