% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcontrib.R
\name{netcontrib}
\alias{netcontrib}
\alias{print.netcontrib}
\title{Contribution matrix in network meta-analysis}
\usage{
netcontrib(x)

\method{print}{netcontrib}(
  x,
  comb.fixed = x$x$comb.fixed,
  comb.random = x$x$comb.random,
  digits = 4,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta} or \code{netcontrib}.}

\item{comb.fixed}{A logical indicating whether a league table
should be printed for the fixed effects (common effects) network
meta-analysis.}

\item{comb.random}{A logical indicating whether a league table
should be printed for the random effects network meta-analysis.}

\item{digits}{number of rounding digits}

\item{\dots}{Additional arguments (ignored at the moment).}
}
\value{
An object of class \code{netcontrib} with corresponding
\code{print} function. The object is a list containing the
following components:
\item{fixed}{Numeric matrix of percentage contributions of direct
  comparisons for each network comparison for the fixed effects
  model.}
\item{random}{Numeric matrix of percentage contributions of direct
  comparisons for each network comparison for the random effects
  model.}
\item{x}{As defined above.}
with the contribution matrices for fixed and random NMA. Each
matrix has the percentage contributions of each direct comparison
as columns for each network comparison, direct or indirect as rows.
}
\description{
This function generates the contribution of direct comparisons to
every network treatment comparison as a different row
}
\details{
In network meta-analysis, it is important to assess the influence
of the limitations or other characteristics of individual studies
on the estimates obtained from the network. The contribution
matrix, shows how much each direct treatment effect contributes to
each treatment effect estimate from network meta-analysis, is
crucial in this context.

We use ideas from graph theory to derive the proportion that is
contributed by each direct treatment effect.  We start with the
‘projection’ matrix in a two-step network meta-analysis model,
called the H matrix, which is analogous to the hat matrix in a
linear regression model.  We develop a method to translate H
entries to proportion contributions based on the observation that
the rows of H can be interpreted as flow networks, where a stream
is defined as the composition of a path and its associated flow.
We present an algorithm that identifies the flow of evidence in
each path and decomposes it into direct comparisons.
}
\examples{
# Use the Woods dataset
#
data("Woods2010")
p1 <- pairwise(treatment, event = r, n = N,
               studlab = author, data = Woods2010, sm = "OR")

net1 <- netmeta(p1)
cm <- netcontrib(net1)
cm

}
\references{
Papakonstantinou, T., Nikolakopoulou, A., Rücker, G., Chaimani, A.,
Schwarzer, G., Egger, M., Salanti, G. (2018):
Estimating the contribution of studies in network meta-analysis:
paths, flows and streams.
\emph{F1000Research}
}
\seealso{
\code{\link{netmeta}}
}
\author{
Thodoris Papakonstantinou \email{dev@tpapak.com}
}
\keyword{contribution}
