% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmap_plot.R
\name{netmap_plot}
\alias{netmap_plot}
\title{Plot a network object with a layout based on an \code{sf} object}
\usage{
netmap_plot(n, m, lkp = NULL, m_name = NULL, n_name = "vertex.names", ...)
}
\arguments{
\item{n}{A \code{network} or \code{igraph} object.}

\item{m}{A \code{sf} object.}

\item{lkp}{An optional lookup table.}

\item{m_name}{Optional \code{character}, name of field in \code{m} and of
column in \code{lkp}.}

\item{n_name}{Optional \code{character}, name of vertex attribute in \code{n}
and of column in \code{lkp}.}

\item{...}{Additional parameters passed to \code{\link[network]{plot.network}}.}
}
\value{
A plot of the network.
}
\description{
Wrapper for \code{\link[network]{plot.network}} and
\code{\link[igraph]{plot.igraph}} using a custom network layout that extracts
coordinates of centroids from a \code{sf} object. Only vertices with a
corresponding feature are plotted.
}
\examples{
net=network::network(matrix(c(0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0), nrow=4, byrow=TRUE))
network::set.vertex.attribute(net, "name", value=c("a", "b", "c", "d"))
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1641",
"01010000204071000000000000801A084100000000AC5C1441",
"01010000204071000000000000801A044100000000AC5C1241",
"01010000204071000000000000801A024100000000AC5C1841"), class = "WKB")
map=sf::st_sf(id=c("a1", "b2", "c3", "d4"), sf::st_as_sfc(wkb, EWKB=TRUE))
lkptbl=data.frame(id=c("a1", "b2", "c3", "d4"), name=c("a", "b", "c", "d"))
netmap::netmap_plot(net, map, lkptbl, "id", "name")
}
