% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{edges_coords}
\alias{edges_coords}
\title{Compute ego/alter edge coordinates considering alter's size and aspect ratio}
\usage{
edges_coords(graph, toa, x, y, vertex_cex, undirected = TRUE,
  no_contemporary = TRUE, dev = as.numeric(c()), ran = as.numeric(c()),
  curved = as.logical(c()))
}
\arguments{
\item{graph}{A square matrix of size \eqn{n}. Adjacency matrix.}

\item{toa}{Integer vector of size \eqn{n}. Times of adoption.}

\item{x}{Numeric vector of size \eqn{n}. x-coordinta of vertices.}

\item{y}{Numeric vector of size \eqn{n}. y-coordinta of vertices.}

\item{vertex_cex}{Numeric vector of size \eqn{n}. Vertices' sizes in terms
of the x-axis (see \code{\link{symbols}}).}

\item{undirected}{Logical scalar. Whether the graph is undirected or not.}

\item{no_contemporary}{Logical scalar. Whether to return (compute) edges'
coordiantes for vertices with the same time of adoption (see details).}

\item{dev}{Numeric vector of size 2. Height and width of the device (see details).}

\item{ran}{Numeric vector of size 2. Range of the x and y axis (see details).}

\item{curved}{Logical vector.}
}
\value{
A numeric matrix of size \eqn{m\times 5}{m * 5} with the following
columns:
\item{x0, y0}{Edge origin}
\item{x1, y1}{Edge target}
\item{alpha}{Relative angle between \code{(x0,y0)} and \code{(x1,y1)} in terms
of radians}
With \eqn{m} as the number of resulting edges.
}
\description{
Given a graph, vertices' positions and sizes, calculates the absolute positions
of the endpoints of the edges considering the plot's aspect ratio.
}
\details{
In order to make the plot's visualization more appealing, this function provides
a straight forward way of computing the tips of the edges considering the
aspect ratio of the axes range. In particular, the following corrections are
made at the moment of calculating the egdes coords:

\itemize{
\item{Instead of using the actual distance between ego and alter, a relative
one is calculated as follows
\deqn{d'=\left[(x_0-x_1)^2 + (y_0' - y_1')^2\right]^\frac{1}{2}}{d'=sqrt[(x0-x1)^2 + (y0'-y1')^2]}
where \eqn{%
y_i'=y_i\times\frac{\max x - \min x}{\max y - \min y} }{%
yi' = yi * [max(x) - min(x)]/[max(y) - min(y)]}
}
\item{Then, for the relative elevation angle, \code{alpha}, the relative distance \eqn{d'}
is used, \eqn{\alpha'=\arccos\left( (x_0 - x_1)/d' \right)}{\alpha' = acos[ (x0 - x1)/d' ]}}
\item{Finally, the edge's endpoint's (alter) coordinates are computed as follows: %
\deqn{%
  x_1' = x_1 + \cos(\alpha')\times v_1}{%
  x1' = x1 + cos(\alpha') * v1
}
\deqn{%
  y_1' = y_1 -+ \sin(\alpha')\times v_1 \times\frac{\max y - \min y}{\max x - \min x} }{%
  y1' = y1 -+ sin(\alpha')*[max(y) - min(y)]/[max(x) - min(x)]
}
Where \eqn{v_1}{v1} is alter's size in terms of the x-axis, and the sign of
the second term in \eqn{y_1'}{y1'} is negative iff \eqn{y_0 < y_1}{y0<y1}.
}
}

The same process (with sign inverted) is applied to the edge starting piont.
The resulting values, \eqn{x_1',y_1'}{x1',y1'} can be used with the function
\code{\link{arrows}}. This is the workhorse function used in \code{\link{plot_threshold}}.

The \code{dev} argument provides a reference to rescale the plot accordingly
to the device, and former, considering the size of the margins as well (this
can be easily fetched via \code{par("pin")}, plot area in inches).

On the other hand, \code{ran} provides a reference for the adjustment
according to the range of the data, this is \code{range(x)[2] - range(x)[1]}
and \code{range(y)[2] - range(y)[1]} respectively.
}
\examples{
# --------------------------------------------------------------------------
data(medInnovationsDiffNet)
library(sna)

# Computing coordinates
set.seed(79)
coords <- sna::gplot(as.matrix(medInnovationsDiffNet$graph[[1]]))

# Getting edge coordinates
vcex <- rep(1.5, nnodes(medInnovationsDiffNet))
ecoords <- edges_coords(
  medInnovationsDiffNet$graph[[1]],
  diffnet.toa(medInnovationsDiffNet),
  x = coords[,1], y = coords[,2],
  vertex_cex = vcex,
  dev = par("pin")
  )

ecoords <- as.data.frame(ecoords)

# Plotting
symbols(coords[,1], coords[,2], circles=vcex,
  inches=FALSE, xaxs="i", yaxs="i")

with(ecoords, arrows(x0,y0,x1,y1, length=.1))
}
\keyword{dplot}
\keyword{misc}
