% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjmat.r
\name{approx_geodesic}
\alias{approx_geodesic}
\alias{Geodesic}
\alias{Shortest-Path}
\alias{approx_geodist}
\title{Approximate Geodesic Distances}
\usage{
approx_geodesic(graph, n = 6L, warn = FALSE)

approx_geodist(graph, n = 6L, warn = FALSE)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{n}{Integer scalar. Degree of approximation. Bigger values increase
precision (see details).}

\item{warn}{Logical scalar. When \code{TRUE}, it warns if the algorithm
performs less steps than required.}
}
\value{
A sparse matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} of size
\code{nnodes(graph)^2} with geodesic distances up to \code{n}.
}
\description{
Computes approximate geodesic distance matrix using graph powers and keeping
the amount of memory used low.
}
\details{
While both \pkg{igraph} and \pkg{sna} offer very good and computationally
efficient routines for computing geodesic distances, both functions return
dense matrices, i.e. not sparse, which can be troublesome. Furthermore,
from the perspective of social network analysis, path lengths of more than 6 steps,
for example, may not be meaningful, or at least, relevant for the researcher.
In such cases, \code{approx_geodesic} serves as a solution to this problem,
computing geodesics up to the number of steps, \code{n}, desired, hence,
if \code{n = 6}, once the algorithm finds all paths of 6 or less steps it
will stop, returning a sparse matrix with zeros for those pairs of
vertices for which it was not able to find a path with less than \code{n}
steps.

Depending on the graph size and density, \code{approx_geodesic}'s performance
can be compared to that of \code{\link[sna:geodist]{sna::geodist}}. Although,
as \code{n} increases, \code{geodist} becomes a better alternative.

The algorithm was implemented using power graphs. At each itereation i the
power graph of order \code{i} is computed, and its values are compared
to the current values of the geodesic matrix (which is initialized in zero).

\enumerate{
\item Initialize the output \code{ans(n, n)}
\item For \code{i=1} to \code{i < n} do
\enumerate{
  \item Iterate through the edges of \code{G^i}, if \code{ans} has a zero
  value in the corresponding row+column, replace it with \code{i}
  \item next
}
\item Replace all diagonal elements with a zero and return.
}

This implementation can be more memory efficient that the aforementioned ones,
but at the same time it can be significant slower.

\code{approx_geodist} is just an allias for \code{approx_geodesic}.
}
\examples{
# A very simple example -----------------------------------------------------
g <- ring_lattice(10, 3)
approx_geodesic(g, 6)
sna::geodist(as.matrix(g))[[2]]
igraph::distances(
  igraph::graph_from_adjacency_matrix(g),
  mode = "out"
)

}
