% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diffnet2.R
\name{plot_diffnet2}
\alias{plot_diffnet2}
\alias{plot_diffnet2.default}
\alias{plot_diffnet2.diffnet}
\title{Another way of visualizing diffusion}
\usage{
plot_diffnet2(graph, ...)

\method{plot_diffnet2}{diffnet}(graph, toa = NULL, slice = nslices(graph),
  color.ramp = grDevices::colorRamp(c("skyblue", "yellow", "red")),
  layout = NULL, key.width = 0.1, key.title = "Time of Adoption",
  main = "Diffusion dynamics", vertex.size = NULL, vertex.shape = NULL,
  vertex.label = "", vertex.frame.color = "gray", edge.arrow.size = 0.5,
  edge.curved = FALSE, add.map = NULL, diffmap.args = list(kde2d.args =
  list(n = 100)), diffmap.alpha = 0.5, include.white = "first",
  rescale.fun = rescale_vertex_igraph, ...)

\method{plot_diffnet2}{default}(graph, toa, pers = min(toa, na.rm =
  TRUE):max(toa, na.rm = TRUE), color.ramp = grDevices::colorRamp(c("skyblue",
  "yellow", "red")), layout = NULL, key.width = 0.1,
  key.title = "Time of\\nAdoption", main = "Diffusion dynamics",
  vertex.size = NULL, vertex.shape = NULL, vertex.label = "",
  vertex.frame.color = "gray", edge.arrow.size = 0.5, edge.curved = FALSE,
  add.map = NULL, diffmap.args = list(kde2d.args = list(n = 100)),
  diffmap.alpha = 0.5, include.white = "first",
  rescale.fun = rescale_vertex_igraph, ...)
}
\arguments{
\item{graph}{Either a square matrix or a diffnet object.}

\item{...}{Further arguments passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{toa}{Integer vector of length \eqn{n} with the times of adoption.}

\item{slice}{Integer scalar. Number of slice to use as baseline for drawing the graph.}

\item{color.ramp}{A function as returned by \code{\link[grDevices:colorRamp]{colorRamp}}.}

\item{layout}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{key.width}{Numeric scalar. Sets the proportion of the plot (x-axis) that the key uses.}

\item{key.title}{Character scalar. Title of the key (vertex colors).}

\item{main}{Character scalar. Title of the graph.}

\item{vertex.size}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{vertex.shape}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{vertex.label}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{vertex.frame.color}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{edge.arrow.size}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{edge.curved}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{add.map}{Character scalar. When \code{"first"} plots a \code{\link{diffusionMap}} before the
graph itself. If \code{"last"} then it adds it at the end. When \code{NULL} adds nothing.}

\item{diffmap.args}{List. If \code{add.map=TRUE}, arguments passed to \code{diffusionMap}.}

\item{diffmap.alpha}{Numeric scalar between [0,1]. Alpha level for the map.}

\item{include.white}{Character scalar. Includes white in the color palette used in the map.
When \code{include.white=NULL} then it won't include it.}

\item{rescale.fun}{A function to rescale vertex size. By defult it is set to be \code{\link{rescale_vertex_igraph}}}

\item{pers}{Integer vector of length \eqn{T} indicating the time periods of the data.}
}
\value{
A list with the following elements
\item{layout}{A numeric matrix with vertex coordinates.}
\item{vertex.color}{A character vector with computed colors for each vertex.}
\item{vertex.label}{The value passed to \code{plot_diffnet2}.}
\item{vertex.shape}{A character vector with assigned shapes.}
\item{vertex.size}{A numeric vector with vertices sizes}
\item{diffmap}{If \code{add.map=TRUE}, the returned values from \code{\link{diffmap}}}
}
\description{
Another way of visualizing diffusion
}
\details{
If \code{key.width<=0} then no key is created.
}
\author{
George G. Vega Yon
}
\seealso{
Other visualizations: \code{\link{diffusionMap}},
  \code{\link{drawColorKey}}, \code{\link{hazard_rate}},
  \code{\link{plot_adopters}}, \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}

