% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grid_distribution}
\alias{grid_distribution}
\title{Distribution over a grid}
\usage{
grid_distribution(x, y, nlevels = 100L)
}
\arguments{
\item{x}{Numeric vector of size \eqn{n}}

\item{y}{Numeric vector of size \eqn{n}}

\item{nlevels}{Integer scalar. Number of bins to return}
}
\value{
Returns a list with three elements
\item{x}{Numeric vector of size \code{nlevels} with the class marks for x}
\item{y}{Numeric vector of size \code{nlevels} with the class marks for y}
\item{z}{Numeric matrix of size \code{nlevels} by \code{nlevels} with the distribution %
of the elements in terms of frecuency}
}
\description{
Distribution of pairs over a grid of fix size.
}
\details{
This function ment for internal use only.
}
\section{Examples}{

\preformatted{
# Generating random vectors of size 100
x <- rnorm(100)
y <- rnorm(100)

# Calculating distribution
grid_distribution(x,y,20)
}
}
\seealso{
Used by \code{\link{plot_infectsuscep}}
}
\keyword{dplot}
\keyword{misc}

