% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_test.R
\name{struct_test}
\alias{hist.diffnet_struct_test}
\alias{print.diffnet_struct_test}
\alias{struct_test}
\title{Structure dependence test}
\usage{
struct_test(graph, statistic, R, rewire.args = list(p = c(2000, rep(100,
  nslices(graph) - 1)), undirected = getOption("diffnet.undirected", FALSE),
  copy.first = TRUE, algorithm = "swap"), ...)

\method{print}{diffnet_struct_test}(x, ...)

\method{hist}{diffnet_struct_test}(x,
  main = "Empirical Distribution of Statistic", xlab = expression(Values ~
  of ~ t), breaks = 20, annotated = TRUE, b0 = expression(atop(plain("")
  \%up\% plain("")), t[0]), b = expression(atop(plain("") \%up\% plain("")),
  t[]), ...)
}
\arguments{
\item{graph}{A \code{\link{diffnet}} graph.}

\item{statistic}{A function that returns either a scalar or a vector.}

\item{R}{Integer scalar. Number of repetitions.}

\item{rewire.args}{List. Arguments to be passed to \code{\link{rewire_graph}}}

\item{...}{Further arguments passed to the method (see details).}

\item{x}{A \code{diffnet_boot} class object.}

\item{main}{Character scalar. Title of the histogram.}

\item{xlab}{Character scalar. x-axis label.}

\item{breaks}{Passed to \code{\link{hist}}.}

\item{annotated}{Logical scalar. When TRUE marks the observed data average and the simulated data average.}

\item{b0}{Character scalar. When \code{annotated=TRUE}, label for the value of \code{b0}.}

\item{b}{Character scalar. When \code{annotated=TRUE}, label for the value of \code{b}.}
}
\value{
A list of class \code{diffnet_bot} containing the following:
\item{graph}{The graph passed to \code{struct_test}.}
\item{p.value}{The resulting p-value of the test (see details).}
\item{t0}{The observed value of the statistic.}
\item{mean_t}{The average value of the statistic applied to the simulated networks.}
\item{R}{Number of simulations.}
\item{statistic}{The function \code{statistic} passed to \code{struct_test}.}
\item{boot}{A \code{boot} class object as return from the call to \code{boot}.}

The output from the \code{hist} method is the same as \code{\link{hist.default}}.
}
\description{
Test whether or not a network estimates can be considered structurally dependent, i.e.
a function of the network structure. By rewiring the graph and calculating
a particular statistic \eqn{t}, the test compares the observed mean of \eqn{t}
against the empirical distribution of it obtained from rewiring the network.
}
\details{
\code{struct_test} is a wrapper for the function \code{\link[boot:boot]{boot}} from the
\pkg{boot} package. Instead of resampling data--vertices or edges--in each iteration the function
rewires the original graph using \code{\link{rewire_graph}} and applies
the function defined by the user in \code{statistic}. In particular, the \code{"swap"} algorithm
is used in order to preserve the degree sequence of the graph, in other words,
each rewired version of the original graph has the same degree sequence.

In \code{struct_test} \code{\dots} are passed to \code{boot}, otherwise are passed
to the corresponding method (\code{\link{hist}} for instance).

From the \code{print} method, p-value for the null of the statistic been
equal between graph and its rewired versions is computed as follows

\deqn{%
p(\tau)=2\times\min\left(\mbox{Pr}(t\leq\tau), \mbox{Pr}(t\geq\tau)\right) %
}{ %
p(tau) = 2*min[Pr(t<=tau), Pr(t>=tau)] %
}

Where \eqn{\mbox{Pr}\{\cdot\}}{Pr(.)} is approximated using the
Empirical Distribution Function retrieved from the simulations.

The test is actually on development by Vega Yon and Valente. A copy of the
working paper can be distributed upon request to \email{g.vegayon@gmail.com}
}
\examples{
# Creating a random graph
set.seed(881)
diffnet <- rdiffnet(500, 10, seed.graph="small-world")

# Testing structure-dependency of threshold
res <- struct_test(diffnet, function(g) mean(threshold(g), na.rm=TRUE), R=100)
res
hist(res)

# Adding a legend
legend("topright", bty="n",
 legend=c(
   expression(t[0]:~Baseline),
   expression(t:~Rewired~average)
 )
 )

# Running in parallel fashion
\dontrun{
res <- struct_test(diffnet, function(g) mean(threshold(g), na.rm=TRUE), R=100,
ncpus=4, parallel="multicore")
res
hist(res)
}
}
\author{
George G. Vega Yon
}
\references{
Vega Yon, George G. and Valente, Thomas W. (On development).

Davidson, R., & MacKinnon, J. G. (2004). Econometric Theory and Methods. New York:
Oxford University Press.
}

