% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{recode}
\alias{recode}
\alias{recode.data.frame}
\alias{recode.matrix}
\title{Recodes an edgelist such that ids go from 1 to n}
\usage{
recode(data, ...)

\method{recode}{data.frame}(data, ...)

\method{recode}{matrix}(data, ...)
}
\arguments{
\item{data}{Edgelist as either a matrix or dataframe with ego and alter}

\item{...}{Further arguments for the method (ignored)}
}
\value{
A recoded edgelist as a two-column matrix/data.frame depending
on the class of \code{data}. The output includes an attribute called "recode"
which contains a two column data.frame providing a mapping between the
previous code and the new code (see the examples)
}
\description{
Recodes an edgelist such that ids go from 1 to n
}
\details{
Required for using most of the package's functions, as ids are used
as a reference for accessing elements in adjacency matrices.
}
\examples{
# Simple example
edgelist <- cbind(c(1,1,3,6),c(4,3,200,1))
edgelist
recoded_edgelist <- recode(edgelist)
recoded_edgelist

# Retrieving the "recode" attribute
attr(recoded_edgelist, "recode")
}
\author{
George G. Vega Yon
}
\seealso{
\code{\link{edgelist_to_adjmat}}
}
\keyword{misc}

