% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_data.R
\name{classify_graph}
\alias{classify_graph}
\title{Analyze an R object to identify the class of graph (if any)}
\usage{
classify_graph(graph)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}
}
\value{
Whe the object fits any of the accepted graph formats, a list of attributes including
\item{type}{Character scalar. Whether is a static or a dynamic graph}
\item{class}{Character scalar. The class of the original object}
\item{ids}{Character vector. Labels of the vertices}
\item{pers}{Integer vector. Labels of the time periods}
\item{nper}{Integer scalar. Number of time periods}
\item{n}{Integer scalar. Number of vertices in the graph}
Otherwise returns with error.
}
\description{
Analyze an R object to identify the class of graph (if any)
}
\details{
This function analyzes an R object and tries to classify it among the
accepted classes in \pkg{netdiffuseR}. If the object fails to fall in one of
the types of graphs the function returns with an error indicating what (and
when possible, where) the problem lies.

The function was designed to be used with \code{\link{as_diffnet}}.
}
\author{
Vega Yon
}
\seealso{
\code{\link{as_diffnet}}, \code{\link{netdiffuseR-graphs}}
}

