% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nestedRanksTest.R
\name{nestedRanksTest_weights}
\alias{nestedRanksTest_weights}
\title{Calculates weights for \code{nestedRanksTest} based on group sizes.}
\usage{
nestedRanksTest_weights(x, groups)
}
\arguments{
\item{x}{Treatments, coerced to factor.  Must contain two levels.}

\item{groups}{Groups, coerced to factor, with elements in the same order
               as for \code{x}.}
}
\value{
\code{data.frame} containing weights and other information for
        each group: columns \code{group}, a factor of group names, also
        used for row names; \code{n1}, \code{n2}, and \code{n1.n2} for
        integer group sizes in the first and second treatment levels and
        their product; and numeric \code{weights} for the calculated
        weights.
}
\description{
\code{ntestedRanksTest_weights} is used by \code{nestedRanksTest} to
calculate group weights based on group sizes.  The number of group members
in each of the two treatment levels is determined (\code{n1} and \code{n2})
together with their product (\code{n1.n2}), and the group-specific weight
is calculated by dividing \code{n1.n2} by the sum of \code{n1.n2} for all
groups.
}
\seealso{
\code{\link{nestedRanksTest}}
}

