% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byTileAOP.R
\name{byTileAOP}
\alias{byTileAOP}
\title{Download AOP tiles overlapping specified coordinates for a given site, year, and product}
\usage{
byTileAOP(dpID, site = "SJER", year = "2017", easting, northing,
  buffer = 0, check.size = TRUE, savepath = NA)
}
\arguments{
\item{dpID}{The identifier of the NEON data product to pull, in the form DPL.PRNUM.REV, e.g. DP1.10023.001}

\item{site}{The four-letter code of a single NEON site, e.g. 'CLBJ'.}

\item{year}{The four-digit year to search for data. Defaults to 2017.}

\item{easting}{A vector containing the easting UTM coordinates of the locations to download.}

\item{northing}{A vector containing the northing UTM coordinates of the locations to download.}

\item{buffer}{Size, in meters, of the buffer to be included around the coordinates when determining which tiles to download. Defaults to 0. If easting and northing coordinates are the centroids of NEON TOS plots, use buffer=20.}

\item{check.size}{T or F, should the user be told the total file size before downloading? Defaults to T. When working in batch mode, or other non-interactive workflow, use check.size=F.}

\item{savepath}{The file path to download to. Defaults to NA, in which case the working directory is used.}
}
\value{
A folder in the working directory, containing all files meeting query criteria.
}
\description{
Query the API for AOP data by site, year, product, and tile location, and download all files found.
Downloads serially to avoid overload; may take a very long time.
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
Christine Laney \email{claney@battelleecology.org}
}
