% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/quantile.R
\docType{methods}
\name{quantile,distancematrix-method}
\alias{quantile}
\alias{quantile,distancematrix-method}
\title{Quantile for upper-triangular values in distance matrix}
\usage{
\S4method{quantile}{distancematrix}(x, probs, ...)
}
\arguments{
\item{x}{A distancematrix object.}

\item{probs}{numeric vector or probabilities with values in [0,1].}

\item{\dots}{Additional arguments, passed to \code{\link[stats]{quantile}}.}
}
\value{
numeric vector of quantiles corresponding to the given probabilities
}
\description{
Extend the stats \code{\link[stats]{quantile}} function for handling distancematrix objects.
}
\details{
The upper.triangular values of the distance matrix object are passed to the
\code{\link{quantile}} function.
}
\examples{
plainmatrix<-as.matrix(dist(sample(1:25, 8, replace=TRUE)))
mdm<-distancematrix(plainmatrix)
quantile(mdm, probs=c(0.0, 0.25, 0.50, 0.75, 1.00))
}
\author{
Cole Beck
}

