% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{as_nanoarrow_schema}
\alias{as_nanoarrow_schema}
\alias{infer_nanoarrow_schema}
\alias{nanoarrow_schema_parse}
\alias{nanoarrow_schema_modify}
\title{Convert an object to a nanoarrow schema}
\usage{
as_nanoarrow_schema(x, ...)

infer_nanoarrow_schema(x, ...)

nanoarrow_schema_parse(x, recursive = FALSE)

nanoarrow_schema_modify(x, new_values, validate = TRUE)
}
\arguments{
\item{x}{An object to convert to a schema}

\item{...}{Passed to S3 methods}

\item{recursive}{Use \code{TRUE} to include a \code{children} member when parsing
schemas.}

\item{new_values}{New schema component to assign}

\item{validate}{Use \code{FALSE} to skip schema validation}
}
\value{
An object of class 'nanoarrow_schema'
}
\description{
In nanoarrow a 'schema' refers to a \verb{struct ArrowSchema} as defined in the
Arrow C Data interface. This data structure can be used to represent an
\code{\link[arrow:Schema]{arrow::schema()}}, an \code{\link[arrow:Field]{arrow::field()}}, or an \code{arrow::DataType}. Note that
in nanoarrow, an \code{\link[arrow:Schema]{arrow::schema()}} and a non-nullable \code{\link[arrow:data-type]{arrow::struct()}}
are represented identically.
}
\examples{
infer_nanoarrow_schema(integer())
infer_nanoarrow_schema(data.frame(x = integer()))

}
