% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{ReadImageData}
\alias{ReadImageData}
\title{Read image as array object.}
\usage{
ReadImageData(image.name, fix.lut = NULL)
}
\arguments{
\item{image.name}{The path to the image file on disk. The file extension must
be one of '.jpeg', '.png', '.tiff' or '.tif'.}

\item{fix.lut}{When reading in images (via \code{\link[EBImage:readImage]{EBImage::readImage()}}), R can
give an array of different dimensionality than you expect. If you suspect
this happening, set the value of this parameter to the \emph{number of
dimensions} that you expect your read image to have and this function will
try to automatically give you the image array in the form you want. Read
\code{\link[=FixLUTError]{FixLUTError()}} to find out more.}
}
\value{
An array of integers representing the image.
}
\description{
Read in an image file from the disk as an array of pixel intensities.
}
\details{
This function wraps \code{\link[EBImage:readImage]{EBImage::readImage()}} and \code{\link[EBImage:imageData]{EBImage::imageData()}}. By
default, \code{readImage} reads in pixel intensities in the range \code{[0, 1]}.
\code{ReadImageData} reads in pixel intensities as integers as they would be
represented in a tiff file and displayed therefrom in ImageJ. This is
necessary when calculating number and brightness, where we need pixel values
to be in units of 'counts'.

Thinking of the read image as a matrix \code{mat}, the pixel at \eqn{x = }\code{i},
\eqn{y = }\code{j} has colour based on the value of \code{mat[i, j]} where the
\eqn{x} axis points right and the \eqn{y} axis points down. This is in
accordance with how \link[EBImage:EBImage]{EBImage::EBImage}'s \code{\link[EBImage:readImage]{EBImage::readImage()}} (which this
function wraps). However, when one prints a matrix in a console (or views it
in a program such as excel), the value in position \eqn{x = }\code{i}, \eqn{y =
}\code{j} is from \code{mat[j, i]}, so if you're confused about a phantom
transposition, this is why.

Sometimes (for whatever reason) the reading of image values as integers with
\code{readTIFF(..., as.is = TRUE)} fails such that the values which should be 1,
2, 3 etc. end up as 256, 512, 778 etc. This function corrects for this as
follows: if the greatest common divisor of the elements in the array are one
of 2^8, 2^12, 2^16 or 2^32, then divide each element of the array by this
greatest common divisor. This will return 256, 512, 778 etc. to 1, 2, 3 etc.
}
\examples{
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))

}
