################################################
#Adapted from part of the 'inverseA' function
# written by Jarrod Hadfield
#in the 'MCMCglmm' package
################################################

makeAinv <- function(pedigree, det = FALSE)
{
  numped <- numPed(pedigree)
  N <- dim(numped)[1]
  dnmiss <- which(numped[, 2] != -998)
  snmiss <- which(numped[, 3] != -998)
  bnmiss <- which(numped[, 2] != -998 & numped[, 3] != -998)
  Tinv.row <- c(numped[, 1][dnmiss], numped[, 1][snmiss], 1:N)
  Tinv.col <- c(numped[, 2][dnmiss], numped[, 3][snmiss], 1:N)
  Tinv.x <- c(rep(-0.5, length(dnmiss) + length(snmiss)), rep(1, N))
  el.order <- order(Tinv.col + Tinv.row/(N + 1), decreasing = FALSE)
  Tinv <- Matrix(0, N, N, sparse = TRUE)
  Tinv[1, 2] <- 1
  Tinv@i <- as.integer(Tinv.row[el.order] - 1)
  Tinv@p <- as.integer(c(match(1:N, Tinv.col[el.order]), length(el.order) + 1) - 1)
  Tinv@x <- as.double(Tinv.x[el.order])
  nA <- N + 2 * length(dnmiss) + 2 * length(snmiss)
  nA <- nA + 2 * sum(duplicated(paste(numped[, 2], numped[, 3])[bnmiss]) == FALSE)
  inbreeding <- c(rep(0, N), -1)
  numped[numped == -998] <- N + 1
    Cout <- .C("ainv",
	    as.integer(numped[, 2] - 1), #dam
	    as.integer(numped[, 3] - 1),  #sire
	    as.double(inbreeding),  #f
            as.integer(Tinv@i),  #iTinvP
	    as.integer(c(Tinv@p, length(Tinv@x))),  #pTinvP
            as.double(Tinv@x),  #xTinvP
            as.integer(N),   #nTinvP
	    as.integer(length(Tinv@x)), #nzmaxTinvP
	    as.integer(rep(0, nA)), #iAP
	    as.integer(rep(0, N + 1)), #pAP
	    as.double(rep(0, nA)), #xAP
	    as.integer(nA)) #nzmaxAP

   Ainv <- Matrix(0, N, N)
   Ainv[1, 2] <- 1
   Ainv@i <- Cout[[9]][1:Cout[[12]]]
   Ainv@p <- Cout[[10]]
   Ainv@x <- Cout[[11]][1:Cout[[12]]]
   Ainv@Dimnames <- list(pedigree[, 1], NULL)
   if(det) logDet <- -1*determinant(Ainv, logarithm = TRUE)$modulus[1] else logDet <- NULL

return(list(Ainv = Ainv, listAinv = sm2list(Ainv, rownames = pedigree[, 1], colnames = c("row", "column", "Ainv")), f = Cout[[3]][-(N+1)], logDet = logDet))
}

