% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCorrelation.R
\name{PlotCorrelation}
\alias{PlotCorrelation}
\title{Plot the Correlation Between Phylostrata and Divergence Strata}
\usage{
PlotCorrelation(PhyloExpressionSet, DivergenceExpressionSet,
  method = "pearson", linearModel = FALSE)
}
\arguments{
\item{PhyloExpressionSet}{a standard PhyloExpressionSet object.}

\item{DivergenceExpressionSet}{a standard DivergenceExpressionSet object.}

\item{method}{a character string specifying the correlation method to cbe used, e.g. "pearson", "kendall", "spearman".}

\item{linearModel}{a boolean value specifying whether a linear model should be
fitted to the data and furthermore, should be visualized in the corresponding plot.}
}
\value{
a jitter-correlation-plot of PS and DS correlation.
}
\description{
This function plots the correlation coefficient between phylostratum values 
and divergence-stratum values of a given PhyloExpressionSet and DivergenceExpressionSet.
      
This function can be used to test whether a given PS distribution and DS distribution are 
linear correlated so that the independence of PS and DS can be assumed for 
subsequent analyses (Quint et al., 2012).
}
\examples{

 # read standard phylotranscriptomics data
 data(PhyloExpressionSetExample)
 data(DivergenceExpressionSetExample)
 
# plot the PS and DS correlation
PlotCorrelation(PhyloExpressionSetExample, DivergenceExpressionSetExample, 
                method      = "pearson", 
                linearModel = TRUE)



}
\author{
Hajk-Georg Drost
}
\references{
Quint M et al. (2012). \emph{A transcriptomic hourglass in plant embryogenesis}. Nature (490): 98-101.
Drost HG et al. (2015) \emph{Evidence for Active Maintenance of Phylotranscriptomic Hourglass Patterns in Animal and Plant Embryogenesis}. Mol Biol Evol. 32 (5): 1221-1231 doi:10.1093/molbev/msv012.
}
\seealso{
\code{\link{cor}}
}

