% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness_comparisons.R
\name{brightness_comparisons}
\alias{brightness_comparisons}
\title{Voice-leading brightness relationships for a scale's modes}
\usage{
brightness_comparisons(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
An n-by-n matrix where n is the size of the scale. Row i represents mode i of the scale
in comparison to all 7 modes. If the entry in row i, column j is \code{-1}, then mode i is
"voice-leading darker" than mode j. If \code{1}, mode i is "voice-leading brighter". If 0, mode i
is neither brighter nor darker, either because contrary motion is involved or because mode i
is identical to mode j. (Entries on the principal diagonal are always 0.)
}
\description{
The essential step in creating the brightness graph of a scale's modes
is to compute the pairwise comparisons between all the modes. Which ones are strictly
brighter than others according to "voice-leading brightness" (see "Modal Color Theory," 6-7)?
This function makes those pairwise comparisons in a manner that's useful for more computation.
If you want a human-readable version of the same information, you should use \code{\link[=brightnessgraph]{brightnessgraph()}}
instead.
}
\details{
Note that the returned value shows all voice-leading brightness comparisons, not just
the transitive reduction of those comparisons. (That is, dorian is shown as darker than ionian
even though mixolydian intervenes in the brightness graph.)
}
\examples{
# Because the diatonic scale, sc7-35, is non-degenerate well-formed, the only
# 0 entries should be on its diagonal.
brightness_comparisons(sc(7, 35))

mystic_chord <- sc(6,34)
colSums(sim(mystic_chord)) # The sum brightnesses of the mystic chord's 6 modes
brightness_comparisons(mystic_chord) 
# Almost all 0s because very few mode pairs are comparable.
# That's because nearly all modes have the same sum, which means they have sum-brightness
# ties, and voice-leading brightness can't break a sum-brightness tie.
# (See "Modal Color Theory," 7.)

}
