% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{coef_ordered.multiview}
\alias{coef_ordered.multiview}
\title{Extract an ordered list of standardized coefficients from a multiview object}
\usage{
\method{coef_ordered}{multiview}(object, s = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{"multiview"} object.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
coefficients are required.}

\item{...}{This is the mechanism for passing arguments like \verb{x=} when
\code{exact=TRUE}; see \code{exact} argument.}
}
\value{
data frame of consisting of view name, view column,
coefficient and standardized coefficient ordered by rank of
standardized coefficient.
}
\description{
This function extracts a ranked list of coefficients after the coefficients are
standardized by the standard deviation of the corresponding features. The ranking
is based on the magnitude of the standardized coefficients. It also outputs
the data view to which each coefficient belongs.
}
\details{
The output table shows from left to right the data view each coefficient comes from,
the column index of the feature in the corresponding data view, the coefficient
after being standardized by the standard deviation of the corresponding feature,
and the original fitted coefficient.
}
\examples{
# Gaussian
x = matrix(rnorm(100 * 20), 100, 20)
z = matrix(rnorm(100 * 10), 100, 10)
y = rnorm(100)
fit1 = multiview(list(x=x,z=z), y, rho = 0)
coef_ordered(fit1, s=0.1)

# Binomial
by = sample(c(0,1), 100, replace = TRUE)
fit2 = multiview(list(x=x,z=z), by, family = binomial(), rho=0.5)
coef_ordered(fit2, s=0.1)

# Poisson
py = matrix(rpois(100, exp(y))) 
fit3 = multiview(list(x=x,z=z), py, family = poisson(), rho=0.5)
coef_ordered(fit3, s=0.1)

}
