% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VC_library_writing.R
\name{lib.dependencies}
\alias{lib.dependencies}
\title{List the dependencies of a package.}
\usage{
lib.dependencies(
  packageName,
  do_print = TRUE,
  character.only = FALSE,
  lib_location = lib.location()
)
}
\arguments{
\item{packageName}{The (unquoted) package name for which you would like to
print the dependencies.}

\item{do_print}{If true (default), prints the dependencies. In both cases,
the dependencies are returned invisibly.}

\item{character.only}{If TRUE, (FALSE by default), the package names can be
provided as character vector. Otherwise, direct unquoted package names are supported.}

\item{lib_location}{The folder containing the R_MV_library structure where
this function observes the dependencies. By default, it checks the environment
variable \code{R_MV_LIBRARY_LOCATION} for this directory.}
}
\value{
When do_print is TRUE, will print use \code{message} to show the
provided package(s) his dependencies. Also returns the dependencies invisibly.
}
\description{
Provide a package name (can be without quotes) to show its dependencies.
To list all dependencies of the complete library, use the inverse function
"\code{lib.dependsOnMe(all)}" with the value 'all'.
That function also does not require quotes when calling it.
So \code{lib.dependencies(package.a)} will work.
}
\examples{
\dontrun{
    lib.dependencies(dplyr)
    lib.dependencies('devtools', character.only = TRUE)
    devtools_deps <- lib.dependencies(devtools, do_print = FALSE)
}

}
