% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{lib.clean_install_dir}
\alias{lib.clean_install_dir}
\title{Clear the temp install folder.}
\usage{
lib.clean_install_dir(
  lib_location = lib.location(),
  temp_install_location = lib.location_install_dir(lib_location)
)
}
\arguments{
\item{lib_location}{By default the library path returned by \code{lib.location()} is used.
It is only used to build the temp_install.location when that argument is not provided.}

\item{temp_install_location}{The folder that is emptied by this function.}
}
\value{
No return value, it is called for it's side-effect of removing the
  temporary installation folder (located in \code{<multiversion_lib>/TEMP_install_location}).
  This must be called after every installation.
}
\description{
The temporary installation folder (indicated by \code{lib.location_install_dir()}) is used to install the package before moving ('converting') it to the final location.
This function removes this temporary folder. Make sure that all installed packages that are desired to keep are converted.
You can run the \code{\link{lib.convert}()} once again to make sure this is the case.
}
