% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data-class.R
\name{plot.nma_data}
\alias{plot.nma_data}
\title{Network plots}
\usage{
\method{plot}{nma_data}(
  x,
  ...,
  layout,
  circular,
  weight_edges = TRUE,
  weight_nodes = FALSE,
  show_trt_class = FALSE,
  nudge = 0
)
}
\arguments{
\item{x}{A \link{nma_data} object to plot}

\item{...}{Additional arguments passed to \code{\link[=ggraph]{ggraph()}} and on to the layout
function}

\item{layout}{The type of layout to create. Any layout accepted by \code{\link[=ggraph]{ggraph()}}
may be used, including all of the layout functions provided by \link{igraph}.}

\item{circular}{Whether to use a circular representation. See \code{\link[=ggraph]{ggraph()}}.}

\item{weight_edges}{Weight edges by the number of studies? Default is \code{TRUE}.}

\item{weight_nodes}{Weight nodes by the total sample size? Default is \code{FALSE}.}

\item{show_trt_class}{Colour treatment nodes by class, if \code{trt_class} is set?
Default is \code{FALSE}.}

\item{nudge}{Numeric value to nudge the treatment labels away from the nodes
when \code{weight_nodes = TRUE}. Default is \code{0} (no adjustment to label
position). A small value like \code{0.1} is usually sufficient.}
}
\value{
A \code{ggplot} object, as produced by \code{\link[=ggraph]{ggraph()}}.
}
\description{
Create a network plot from a \code{nma_data} network object.
}
\details{
The default is equivalent to \code{layout = "linear"} and \code{circular = TRUE}, which places the treatment nodes on a circle in the order defined by
the treatment factor variable. An alternative layout which may give good
results for simple networks is \code{"sugiyama"}, which attempts to minimise the
number of edge crossings.

\code{weight_nodes = TRUE} requires that sample sizes have been specified for
any aggregate data in the network, using the \code{sample_size} option of
\verb{set_agd_*()}.
}
\examples{
## Stroke prevention in atrial fibrillation
# Setting up the network
af_net <- set_agd_arm(atrial_fibrillation,
                      study = studyc,
                      trt = abbreviate(trtc, minlength = 3),
                      r = r,
                      n = n,
                      trt_class = trt_class)
af_net

# Basic plot
plot(af_net)

# Turn off weighting edges by number of studies
plot(af_net, weight_edges = FALSE)

# Turn on weighting nodes by sample size
plot(af_net, weight_nodes = TRUE)

# Colour treatment nodes by class
plot(af_net, weight_nodes = TRUE, show_trt_class = TRUE)

# Nudge the treatment labels away from the nodes
plot(af_net, weight_nodes = TRUE, show_trt_class = TRUE, nudge = 0.1)

# Output may be customised using standard ggplot commands
# For example, to display the legends below the plot:
plot(af_net, weight_nodes = TRUE, show_trt_class = TRUE) +
  ggplot2::theme(legend.position = "bottom",
                 legend.box = "vertical",
                 legend.margin = ggplot2::margin(0, 0, 0, 0),
                 legend.spacing = ggplot2::unit(0.5, "lines"))

# Choosing a different ggraph layout, hiding some legends
plot(af_net, weight_nodes = TRUE, show_trt_class = TRUE,
     layout = "star") +
  ggplot2::guides(edge_width = "none", size = "none")

}
