% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiblock-package.R
\docType{package}
\name{multiblock}
\alias{multiblock-package}
\alias{multiblock}
\title{multiblock}
\description{
A collection of methods for analysis of data sets with more than two blocks of data.

\strong{Unsupervised methods:}
\itemize{
\item SCA - Simultaneous Component Analysis (\code{\link{sca}})
\item GCA - Generalized Canonical Analysis (\code{\link{gca}})
\item GPA - Generalized Procrustes Analysis (\code{\link{gpa}})
\item MFA - Multiple Factor Analysis (\code{\link{mfa}})
\item PCA-GCA (\code{\link{pcagca}})
\item DISCO - Distinctive and Common Components with SCA (\code{\link{disco}})
\item HPCA - Hierarchical Principal component analysis (\code{\link{hpca}})
\item MCOA - Multiple Co-Inertia Analysis (\code{\link{mcoa}})
\item JIVE - Joint and Individual Variation Explained (\code{\link{jive}})
\item STATIS - Structuration des Tableaux à Trois Indices de la Statistique (\code{\link{statis}})
\item HOGSVD - Higher Order Generalized SVD (\code{\link{hogsvd}})
}

\strong{Design based methods:}
\itemize{
\item ASCA - Anova Simultaneous Component Analysis (\code{\link{asca}})
}

\strong{Supervised methods:}
\itemize{
\item MB-PLS - Multiblock Partial Least Squares (\code{\link{mbpls}})
\item sMB-PLS - Sparse Multiblock Partial Least Squares (\code{\link{smbpls}})
\item SO-PLS - Sequential and Orthogonalized PLS (\code{\link{sopls}})
\item PO-PLS - Parallel and Orthogonalized PLS (\code{\link{popls}})
\item ROSA - Response Oriented Sequential Alternation (\code{\link{rosa}})
\item mbRDA - Multiblock Redundancy Analysis (\code{\link{mbrda}})
}

\strong{Complex methods:}
\itemize{
\item L-PLS - Partial Least Squares in L configuration (\code{\link{lpls}})
\item SO-PLS-PM - Sequential and Orthogonalised PLS Path Modelling (\code{\link{sopls_pm}})
}

\strong{Single- and two-block methods:}
\itemize{
\item PCA - Principal Component Analysis (\code{\link{pca}})
\item PCR - Principal Component Regression (\code{\link{pcr}})
\item PLSR - Partial Least Squares Regression (\code{\link{plsr}})
\item CCA - Canonical Correlation Analysis (\code{\link{cca}})
\item IFA - Interbattery Factor Analysis (\code{\link{ifa}})
\item GSVD - Generalized SVD (\code{\link{gsvd}})
}

\strong{Datasets:}
\itemize{
\item Sensory assessment of candies (\code{\link{candies}})
\item Sensory, rheological, chemical and spectroscopic analysis of potatoes (\code{\link{potato}})
\item Data simulated to have certain characteristics (\code{\link{simulated}})
\item Wines of Val de Loire (\code{\link{wine}})
}

\strong{Utility functions:}
\itemize{
\item Block-wise indexable data.frame (\code{\link{block.data.frame}})
\item Dummy-code a vector (\code{\link{dummycode}})
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
\author{
\strong{Maintainer}: Kristian Hovde Liland \email{kristian.liland@nmbu.no} (\href{https://orcid.org/0000-0001-6468-9423}{ORCID})

Other contributors:
\itemize{
  \item Solve Sæbø [contributor]
  \item Stefan Schrunner [reviewer]
}

}
\keyword{internal}
