% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{gca}
\alias{gca}
\title{Generalized Canonical Analysis - GCA}
\usage{
gca(X, ncomp = "max", svd = TRUE, tol = 10^-12, corrs = TRUE, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract, either single integer (equal for all blocks), vector (individual per block) or 'max' for maximum possible number of components.}

\item{svd}{\code{logical} indicating if Singular Value Decomposition approach should be used (default=TRUE).}

\item{tol}{\code{numeric} tolerance for component inclusion (singular values).}

\item{corrs}{\code{logical} indicating if correlations should be calculated for RGCCA based approach.}

\item{...}{additional arguments for RGCCA approach.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}. \code{blockCoef} contains canonical coefficients, while
\code{blockDecomp} contains decompositions of each block.
}
\description{
This is an interface to both SVD-based (default) and RGCCA-based GCA (wrapping the
\code{RGCCA::rgcca} function)
}
\details{
GCA is a generalisation of Canonical Correlation Analysis to handle three or more
blocks. There are several ways to generalise, and two of these are available through \code{gca}.
The default is an SVD based approach estimating a common subspace and measuring mean squared
correlation to this. An alternative approach is available through RGCCA. For the SVD based
approach, the \code{ncomp} parameter controls the block-wise decomposition while the following
the consensus decomposition is limited to the minimum number of components from the individual blocks.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.gca <- gca(potList)
plot(scores(pot.gca), labels="names")

}
\references{
\itemize{
\item Carroll, J. D. (1968). Generalization of canonical correlation analysis to three or more sets of variables. Proceedings of the American Psychological Association, pages 227-22.
\item Van der Burg, E. and Dijksterhuis, G. (1996). Generalised canonical analysis of individual sensory profiles and instrument data, Elsevier, pp. 221–258.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
