% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lplsData.R
\name{lplsData}
\alias{lplsData}
\title{L-PLS data simulation for exo-type analysis}
\usage{
lplsData(I = 30, N = 20, J = 5, K = 6, ncomp = 2)
}
\arguments{
\item{I}{\code{numeric} number of rows of X1 and X2}

\item{N}{\code{numeric} number of columns in X1 and X3}

\item{J}{\code{numeric} number of columns in X2}

\item{K}{\code{numeric} number of rows in X3}

\item{ncomp}{\code{numeric} number of latent components}
}
\value{
A \code{list} of three matrices with dimensions matching in an L-shape.
}
\description{
Three data blocks are simulated to express covariance in an exo-L-PLS direction (see \code{\link{lpls}}.
Dimensionality and number of underlying components can be controlled.
}
\examples{
lp <- lplsData(I = 30, N = 20, J = 5, K = 6, ncomp = 2)
names(lp)

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
\author{
Solve Sæbø (adapted by Kristian Hovde Liland)
}
