% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toLik.R
\name{discretize}
\alias{discretize}
\title{Transform continous variable to a discrete variable}
\usage{
discretize(x, type = "eq", q = 1.5, k = 5, r = range(x), num = TRUE)
}
\arguments{
\item{x}{Vector with values to be transformed.}

\item{type}{Type of transformation. Possible values are: \code{eq} (default) (equal wide intervals), \code{yes} (wider intervals at higher values of \code{x}), \code{no} (wider intervals at lower values of \code{x}), \code{avg} (wider intervals near the mean of \code{x}).}

\item{q}{Extension factor. Tells how much is each next interval wider then the previous one. Not used when \code{type="eq"}.}

\item{k}{Number of classes.}

\item{r}{Minimum and maximum values to define intervals of \code{x}. Default are minimum and maximum values of \code{x}.}

\item{num}{If \code{TRUE} (default) numberical values are returned, otherwise intervals are returned.}
}
\value{
Transformed values are organized into a vector.
}
\description{
The function transforms a continous variable to a \eqn{k}-point discrete variable (similar to a Likert-item type variable). Different styles of answering to a survey are possible.
}
\examples{
x <- rnorm(1000)
hist(x = discretize(x, type = "eq"), breaks = 0:5+0.5, xlab = "answer", main = "type = 'eq'")
hist(x = discretize(x, type = "yes"), breaks = 0:5+0.5, xlab = "answer", main = "type = 'yes'")
hist(x = discretize(x, type = "no"), breaks = 0:5+0.5, xlab = "answer", main = "type = 'no'")
hist(x = discretize(x, type = "avg"), breaks = 0:5+0.5, xlab = "answer", main = "type = 'avg'")
}
\author{
Aleš Žiberna
}
