% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{qualifierplot}
\alias{qualifierplot}
\alias{autoplot.qtag.long}
\alias{autoplot.qtag.wide}
\alias{plot.qtag.long}
\alias{plot.qtag.wide}
\title{Smart plotting of tidy data frames}
\usage{
qualifierplot(x, id.vars, measure.var, subset, xvar, yvar, facets,
  geom = "path", errors = "err", ...)

\method{autoplot}{qtag.long}(x, ...)

\method{autoplot}{qtag.wide}(x, ...)

\method{plot}{qtag.long}(x, ...)

\method{plot}{qtag.wide}(x, ...)
}
\arguments{
\item{x}{A \code{data.frame}}

\item{id.vars}{Columns that identify unique values}

\item{measure.var}{Column that contains values to be plotted}

\item{subset}{Subset to plot}

\item{xvar}{Column to be used on the x-axis}

\item{yvar}{Column to be used on the y-axis}

\item{facets}{Column to be used as facetting variable}

\item{geom}{GGPlot geometries to be used. Can be any combination of point, path, or line.}

\item{errors}{The colum that contains uncertainty information}

\item{...}{Passed on to \code{aes_string()}}
}
\value{
A ggplot object
}
\description{
This function uses ggplot to plot a 'long' data frame with a few \code{id.vars}, 
or variables that identify the values in the \code{value} column. The function
is optimised to plot multi-parameter spatiotemporal data either horizontally
(time on the x axis) or vertically (time on the y axis). Facets are intended
to be by parameter, which is guessed based on the right-most variable named
in \code{id.vars}. In the case of a \code{qtag} object, many of these values
are guessed. This is intended to produce a quick visual of an object to
examine its contents.
}
\examples{
data(pocmaj)
qualifierplot(pocmaj, c("core", "depth"), "Ca")

pocmajqt <- as.qtag(pocmaj, id.vars=c("core", "depth"))
plot(pocmajqt, geom=c("path", "point"))
plot(pocmajqt, subset=core=="MAJ-1" & param \%in\% c("Ca", "Ti"))
plot(pocmajqt, shape="core", geom=c("path", "point"))
plot(long(pocmajqt))

library(ggplot2)
autoplot(pocmajqt, col="core")

}
