% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse_msaeOBns.R
\name{mse_msaeOBns}
\alias{mse_msaeOBns}
\title{Parametric Bootstrap Mean Squared Error Estimators of Optimum Benchmarking for Multivariate Non Sampled Area in Small Area Estimation}
\usage{
mse_msaeOBns(
  formula,
  vardir,
  weight,
  cluster,
  samevar = FALSE,
  B = 100,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula describe the fitted models}

\item{vardir}{matrix containing sampling variances of direct estimators. The order is: \code{var1, cov12, ..., cov1r, var2, cov23, ..., cov2r, ..., cov(r-1)(r), var(r)}}

\item{weight}{matrix containing proportion of units in small areas. The order is: \code{w1, w2, ..., w(r)}}

\item{cluster}{matrix containing cluster of auxiliary variables. The order is: \code{c1, c2, ..., c(r)}}

\item{samevar}{logical. If \code{TRUE}, the varians is same. Default is \code{FALSE}}

\item{B}{number of bootstrap. Default is 1000}

\item{MAXITER}{maximum number of iterations for Fisher-scoring. Default is 100}

\item{PRECISION}{coverage tolerance limit for the Fisher Scoring algorithm. Default value is \code{1e-4}}

\item{data}{dataframe containing the variables named in formula, vardir, and weight}
}
\value{
\item{mse.eblup}{estimated mean squared errors of the EBLUPs for the small domains based on Prasad Rao}
\item{pbmse.eblupOB}{parametric bootstrap mean squared error estimates of the optimum benchmark}
\item{running.time}{time for running function}
}
\description{
Calculates the parametric bootstrap mean squared error estimates of optimum benchmarking for multivariate non sampled area in small area estimation
}
\examples{
\donttest{
## load dataset
data(datamsaeOBns)

# Compute MSE EBLUP and Optimum Benchmark
# This is the long running example
## Using parameter 'data'
Fo = list(f1 = Y1 ~ X1 + X2,
          f2 = Y2 ~ X1 + X2,
          f3 = Y3 ~ X1 + X2)
vardir = c("v1", "v12", "v13", "v2", "v23", "v3")
weight = c("w1", "w2", "w3")
cluster = c("c1", "c2", "c3")

mse_msae = mse_msaeOBns(Fo, vardir, weight, cluster, data = datamsaeOBns)

## Without parameter 'data'
Fo = list(f1 = datamsaeOBns$Y1 ~ datamsaeOBns$X1 + datamsaeOBns$X2,
          f2 = datamsaeOBns$Y2 ~ datamsaeOBns$X1 + datamsaeOBns$X2,
          f3 = datamsaeOBns$Y3 ~ datamsaeOBns$X1 + datamsaeOBns$X2)
vardir = datamsaeOBns[, c("v1", "v12", "v13", "v2", "v23", "v3")]
weight = datamsaeOBns[, c("w1", "w2", "w3")]
cluster = datamsaeOBns[, c("c1", "c2", "c3")]

mse_msae = mse_msaeOBns(Fo, vardir, weight, cluster)

## Return
mse_msae$pbmse.eblupOB # to see the MSE of Optimum Benchmark
}
}
