\name{mpolyProd}
\alias{*.mpoly}
\alias{mpolyProd}
\title{Multiply multivariate polynomials.}
\usage{
\method{*}{mpoly}(e1, e2)
}
\arguments{
  \item{e1}{an object of class mpoly}

  \item{e2}{an object of class mpoly}
}
\value{
An object of class mpoly.
}
\description{
Compute the product of two mpoly objects.
}
\examples{
x <- mpoly(list(
  c(x = 1, coef = 1),
  c(coef = 1)
))
y <- mpoly(list(
  c(x = 1, coef = 1),
  c(coef = 1)
))
x * y
5 * x
-1 * x


list <- list(
  c(x = 1, coef = 1),
  c(y = 1, coef = -4),
  c(x = 2, z = 1, coef = -3),
  c(t = 3, y = 4, coef = 2)
)
x <- mpoly(list)
y <- mpoly(list(c(x = 1, coef = 1), c(coef = 1)))
( p <- x * y )
reorder(p, order = 'lex', varorder = c('t','x','y','z'))
}

