% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{update.cmp}
\alias{update.cmp}
\title{Update and Re-fit a COM-Poisson Model}
\usage{
\method{update}{cmp}(object, formula., formula_nu., ..., evaluate = TRUE)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}.}

\item{formula.}{changes to the existing formula in \code{object} -- see \code{update.formula}}

\item{formula_nu.}{changes to the existing formula_nu in \code{object} -- see \code{update.formula} for details. It also accepts NULL to not regressing on the dispersion.}

\item{...}{other arguments passed to or from other methods  (currently unused).}

\item{evaluate}{logical; if \code{TRUE} evaluate the new call otherwise simply return
the call}
}
\description{
\code{update} (i.e., \code{update.cmp}) will update and (by-default) re-fit a model. It is
identical to \code{update} in the \code{stats} package.
}
\examples{

# To update the mean regression formula
data(takeoverbids)

## Fit full model 
M.bids.full <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)
M.bids.full
        
## Dropping whtknght
M.bids.null <- update(M.bids.full, .~.-whtknght)
M.bids.null

## To update the dispersion regression formula
data(sitophilus)

## Fit full model 
M.sit.full <- glm.cmp(formula = ninsect ~ extract, formula_nu = ~extract, data = sitophilus)
M.sit.full
        
## Dropping extract from the dispersion regression
M.sit.null1 <- update(M.sit.full, formula_nu =  ~.-extract)
M.sit.null1

## To not regress on the dispersion at all
M.sit.null2 <- update(M.sit.full, formula_nu = NULL)
M.sit.null2
}
\seealso{
\code{\link{glm.cmp}}, \code{\link{update.formula}}, \code{\link{cmplrtest}}.
}
