% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{cmplrtest}
\alias{cmplrtest}
\title{Likelihood Ratio Test for nested COM-Poisson models}
\usage{
cmplrtest(object1, object2, digits = 3)
}
\arguments{
\item{object1}{an object class 'cmp', obtained from a call to \code{glm.cmp}}

\item{object2}{an object class 'cmp', obtained from a call to \code{glm.cmp}}

\item{digits}{numeric; minimum number of significant digits to be used for most numbers.}
}
\description{
Perform a likelihood ratio chi-squared test between nested COM-Poisson models.
The test statistics is calculated as \emph{2*(llik- llik_0)}. The test statistics
has degrees of freedom \emph{r} where \emph{r} is the difference in the number of
parameters between the full and null models.
}
\examples{

## Testing for the mean coefficients
data(takeoverbids)

## Fit full model 
M.bids.full <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)
    
## Fit null model; without whtknght
M.bids.null <- update(M.bids.full, .~.-whtknght)
     
## Likelihood ratio test for the nested models
cmplrtest(M.bids.full, M.bids.null) # order of objects is not important

## Testing for dispersion coefficients
data(sitophilus) 
 M.sit.full <- glm.cmp(formula = ninsect ~ extract, formula_nu = ~extract, data = sitophilus)
 
## Fit null model; dropping extract from dispersion equation
 M.sit.null1 <- update(M.sit.full, formula_nu. = ~1)   
 cmplrtest(M.sit.null1, M.sit.full)

## Fit null model; using constant dispersion specification
M.sit.null2 <- update(M.sit.full, formula_nu. = NULL)   
cmplrtest(M.sit.null2, M.sit.full)

}
\references{
Huang, A. (2017). Mean-parametrized Conway-Maxwell-Poisson regression models for
dispersed counts. \emph{Statistical Modelling} \bold{17}, 359--380.
}
\seealso{
\code{\link{glm.cmp}}, \code{\link{update.cmp}}
}
