% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{LRTnu}
\alias{LRTnu}
\title{Likelihood Ratio Test for nu = 1 of a COM-Poisson model}
\usage{
LRTnu(object, digits = 3)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}}

\item{digits}{numeric; minimum number of significant digits to be used for most numbers.}
}
\description{
Perform a likelihood ratio chi-sqaured test for nu = 1 of a COM-Poisson model. 
The test statistics is calculated as \emph{2*(llik- llik_0)} where \emph{llik} and 
\emph{llik_0} are the log-likelihood of a COM-Poisson and Poisson model respectively.  
The test statistic has 1 degrees of freedom.
}
\examples{
data(takeoverbids)
M.bids <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)
LRTnu(M.bids)
}
\references{
Huang, A. (2017). Mean-parametrized Conway–Maxwell–Poisson regression models for 
dispersed counts. \emph{Statistical Modelling} \bold{17}, 359--380.
}
