context("clustering")
testthat::test_that("Clustering works", {
  require(mosaicData)
  KidsFeet2 <- KidsFeet %>% select(-name, -birthmonth) %>% rescale() 
  M <- dist(KidsFeet2)
  Cl <- hclust(M)
  
  
  testcase1 <- structure(list(x = c(17.642578125, 6.03125, 6.03125), 
                              y = c(2.15388023295916, 2.15388023295916, 1.83303857851649), 
                              xend = c(6.03125, 6.03125, 2.6875), 
                              yend = c(2.15388023295916, 1.83303857851649, 1.83303857851649), 
                              order = c(34L, 34L, 35L), 
                              group = c(4L, 4L, 4L)), 
                         row.names = c(NA,3L), 
                         class = "data.frame")
  
  testcase2 <- structure(list(idx = 1:3, 
                              position = c(15L, 37L, 35L), 
                              variable = c("birthyear","birthyear", "birthyear"), 
                              value = c(1, 0, 0), 
                              variable_num = c(1L, 1L, 1L)), 
                         row.names = c(NA, 3L), 
                         class = "data.frame")
  
  testcase3 <- structure(list(birthyear = c(1, 0, 0), 
                              length = c(0.47457627118644,0.644067796610169, 0.491525423728813), 
                              width = c(0.263157894736842,0.473684210526316, 0.947368421052631), 
                              sex = c(0, 0, 0), 
                              biggerfoot = c(0, 0, 1), 
                              domhand = c(1, 0, 1), 
                              idx = 1:3, 
                              position = c(15L, 37L, 35L)), 
                         row.names = c(NA, 3L), 
                         class = "data.frame")
  
  testcase4 <- structure(list(x = c(1, 2, 3), 
                              y = c(0, 0, 0), 
                              label = structure(1:3, 
                                                .Label = c("6","21", "35", "30", "10", "34", "17", 
                                                           "23", "20", "9", "18", "32","16", "38", 
                                                           "1", "22", "29", "5", "12", "4", "26", 
                                                           "7", "14", "19", "31", "27", "37", "25", 
                                                           "8", "36", "33", "24", "39", "11", "3", 
                                                           "28", "2", "13", "15"), class = "factor"), 
                              order = c(6L,21L, 35L)), 
                         row.names = c(NA, 3L), 
                         class = "data.frame")
  
  expect_equal(testcase1, fortify(Cl, k=5) %>% head(3))
  expect_equal(testcase2, fortify(Cl, which="heatmap", data=KidsFeet2) %>% head(3))
  expect_equal(testcase3, fortify(Cl, which="data", data=KidsFeet2) %>% head(3))
  # seems like ggdendro migth be caught by the stringsAsFactors change, so this 
  # didn't succeed on debian when CRAN checked it.  Removing the check for now  3/5/2020
  # expect_equal(testcase4, fortify(Cl, which="labels") %>% head(3))
  
  
  vdiffr::expect_doppelganger("clustering1", mplot(Cl, data=KidsFeet2, k=4, heatmap=2))
  vdiffr::expect_doppelganger("clustering2", mplot(Cl, data=KidsFeet2, k=4, heatmap=0.5, enumerate="transparent"))
  vdiffr::expect_doppelganger("clustering3", mplot(Cl, data=KidsFeet2, k=4, heatmap=2, type="triangle"))
  vdiffr::expect_doppelganger("clustering4", mplot(Cl, data=KidsFeet2, k=4, heatmap=0, type="triangle"))
})