% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.test.R
\name{binom.test}
\alias{binom.test}
\title{Exact Tests for Proportions}
\usage{
binom.test(
  x,
  n = NULL,
  p = 0.5,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ci.method = c("Clopper-Pearson", "binom.test", "Score", "Wilson", "prop.test", "Wald",
    "Agresti-Coull", "Plus4"),
  data = NULL,
  success = NULL,
  ...
)
}
\arguments{
\item{x}{count of successes, length 2 vector of success and failure counts, a formula,
or a character, numeric, or factor vector containing raw data.}

\item{n}{sample size (successes + failures) or a data frame
(for the formula interface)}

\item{p}{probability for null hypothesis}

\item{alternative}{type of alternative hypothesis}

\item{conf.level}{confidence level for confidence interval}

\item{ci.method}{a method to use for computing the confidence interval
(case insensitive and may be abbreviated).  See details below.}

\item{data}{a data frame (if missing, \code{n} may be a data frame)}

\item{success}{level of variable to be considered success.  All other levels are
considered failure.}

\item{...}{additional arguments (often ignored)}
}
\value{
an object of class \code{htest}
}
\description{
The \code{binom.test()} function
performs an exact test of a simple null hypothesis about the probability of success in a
Bernoulli experiment from summarized data or from raw data.
The mosaic \code{binom.test} provides wrapper functions around the function of the same name in \pkg{stats}.
These wrappers provide an extended interface (including formulas).
}
\details{
\code{binom.test()} is a wrapper around \code{\link[stats:binom.test]{stats::binom.test()}} from the stats
package to simplify its use when the raw data are available, in which case
an extended syntax for \code{binom.test()} is provided.  See the examples.

Also, five confidence interval methods are provided:
*
\verb{"Clopper-Pearson", "binom.test"}: This is the interval produced when using
\code{\link[stats:binom.test]{stats::binom.test()}}
from the stats package.  It guarantees a coverage rate at least as large as
the nominal coverage rate, but may produce wider intervals than some of the methods
below, which may either under- or over-cover depending on the data.
\itemize{
\item `"Score", "Wilson", "prop.test":  This is the usual method used by \code{\link[stats:prop.test]{stats::prop.test()}}
and is computed by inverting p-values from score tests. It is often attributed to
Edwin Wilson.  If specified with \code{"prop.test"}, the continuity correction is applied
(as is the default in \code{\link{prop.test}()}), else the continuity correction is not
applied.
\itemize{
\item \code{"Wald"} This is the interval traditionally taught in entry level statistics courses.
It uses the sample proportion to estimate the standard error and uses normal
theory to determine how many standard deviations to add and/or subtract from
the sample proportion to determine an interval.
\item \"Agresti-Coull"`
This is the Wald method after setting \eqn{n' = n + z^2} and
\eqn{p'= (x + z^2/2) / n}' and using \eqn{x' = n' p'} and \eqn{n'}
in place of \eqn{x} and \eqn{n}.
\item \code{"Plus4"}
This is Wald after adding in two artificial success and two artificial failures.  It
is nearly the same as the Agresti-Coull method when the confidence level is 95\%. since
\eqn{z^2} is approximately 4 and \eqn{z^2/2} is approximately 2.
}
}
}
\note{
When \code{x} is a 0-1 vector, 0 is treated as failure and 1 as success. Similarly,
for a logical vector \code{TRUE} is treated as success and \code{FALSE} as failure.
}
\examples{
# Several ways to get a confidence interval for the proportion of Old Faithful
# eruptions lasting more than 3 minutes.
data(faithful)
binom.test(faithful$eruptions > 3)
binom.test(97, 272)
binom.test(c(97, 272-97))
faithful$long <- faithful$eruptions > 3
binom.test(faithful$long)
binom.test(resample(1:4, 400), p=.25)
binom.test(~ long, data = faithful)
binom.test(~ long, data = faithful, ci.method = "Wald")
binom.test(~ long, data = faithful, ci.method = "Plus4")
with(faithful, binom.test(~long))
with(faithful, binom.test(long))

}
\seealso{
\code{\link[mosaic:prop.test]{mosaic::prop.test()}}, \code{\link[stats:binom.test]{stats::binom.test()}}
}
\keyword{stats}
