% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{makeMap}
\alias{makeMap}
\title{Make a map with \code{ggplot2}}
\usage{
makeMap(data = NULL, map = NULL, key = c(key.data, key.map),
  key.data, key.map, tr.data = identity, tr.map = identity,
  plot = c("borders", "frame", "none"))
}
\arguments{
\item{data}{A dataframe with regions as cases}

\item{map}{An object that can be fortified to a dataframe (ex: a dataframe itself,
or a SpatialPolygonsDataFrame)}

\item{key}{The combination of \code{key.data} and \code{key.map}}

\item{key.data}{The column name in the \code{data} that holds the
unique names of each region}

\item{key.map}{The column name in the \code{map} that holds the
unique names of each region}

\item{tr.data}{A function of the transformation to be performed to
the \code{key.data} column}

\item{tr.map}{A function of the transformation to be performed to
the \code{key.map} column}

\item{plot}{The plot desired for the output. \code{plot} = "none"
returns the merged data that is the result of merging the \code{data}
and \code{map} together; \code{plot}="frame" returns an empty
(unplottable) ggplot object; \code{plot} = "border" (the default)
returns a ggplot object with one geom_polygon layer that shows the
borders of the regions.}
}
\description{
\code{makeMap} takes in two sources of data that refer to geographical
regions and merges them together. Depending on the arguments passed,
it returns this merged data or a ggplot object constructed with the data.
}
