% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdist.R, R/dpqrdist.R
\name{cdist}
\alias{cdist}
\alias{xcgamma}
\alias{xct}
\alias{xcchisq}
\alias{xcf}
\alias{xcbinom}
\alias{xcpois}
\alias{xcgeom}
\alias{xcnbinom}
\alias{xcbeta}
\title{Central portion of a distribution}
\usage{
cdist(dist = "norm", p, plot = TRUE, verbose = FALSE,
  invisible = FALSE, digits = 3L, xlim, ylim, resolution = 500L,
  return = c("values", "plot"), pattern = c("rings", "stripes"), ...,
  refinements = list())

xcgamma(p, shape, rate = 1, scale = 1/rate, lower.tail = TRUE,
  log.p = FALSE, ...)

xct(p, df, ncp, lower.tail = TRUE, log.p = FALSE, ...)

xcchisq(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

xcf(p, df1, df2, lower.tail = TRUE, log.p = FALSE, ...)

xcbinom(p, size, prob, lower.tail = TRUE, log.p = FALSE, ...)

xcpois(p, lambda, lower.tail = TRUE, log.p = FALSE, ...)

xcgeom(p, prob, lower.tail = TRUE, log.p = FALSE, ...)

xcnbinom(p, size, prob, mu, lower.tail = TRUE, log.p = FALSE, ...)

xcbeta(p, shape1, shape2, ncp = 0, lower.tail = TRUE, log.p = FALSE,
  ...)
}
\arguments{
\item{dist}{a character string naming a distribution family (e.g., "norm").
This will work for any family for which the usual d/p/q functions exist.}

\item{p}{the proportion to be in the central region, with equal proportions
in either "tail".}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical indicating whether a more verbose output value should be returned.}

\item{invisible}{a logical}

\item{digits}{the number of digits desired}

\item{xlim}{x limits.  By default, these are chosen to show the central 99.8\%
of the distribution.}

\item{ylim}{y limits}

\item{resolution}{number of points used for detecting discreteness and generating plots.
The default value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{pattern}{One of \code{"stripes"} or \code{"rings"}.
In the latter case, pairs of regions (from the outside to the inside)
are grouped together for coloring and probability calculation.}

\item{...}{additional arguments passed to the distribution functions.  Typically
these specify the parameters of the particular distribution desired.  See the examples.}

\item{refinements}{A list of refinements to the plot.  See \code{\link[ggformula:gf_refine]{ggformula::gf_refine()}}.}

\item{shape}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if \code{TRUE}, probabilities/densities \eqn{p}
    are returned as \eqn{log(p)}.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}

\item{df1}{degrees of freedom.  \code{Inf} is allowed.}

\item{df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{lambda}{vector of (non-negative) means.}

\item{mu}{alternative parametrization via mean: see \sQuote{Details}.}

\item{shape1}{non-negative parameters of the Beta distribution.}

\item{shape2}{non-negative parameters of the Beta distribution.}
}
\value{
a pair of numbers indicating the upper and lower bounds, unless \code{verbose} is
\code{TRUE}, in which case a 1-row data frame is returned containing these bounds,
the central probability, the tail probabilities, and the name of the distribution.
}
\description{
This function determines the critical values for isolating
a central portion of a distribution with a specified probability.
This is designed to work especially well for symmetric distributions,
but it can be used with any distribution.
}
\note{
This function is still experimental and changes the input or output
formats are possible in future versions of the package.
}
\examples{
cdist( "norm", .95)
cdist( "t", c(.90, .95, .99), df=5)
cdist( "t", c(.90, .95, .99), df=50)
# plotting doesn't work well when the parameters are not constant
cdist( "t", .95, df=c(3,5,10,20), plot = FALSE)
cdist( "norm", .95, mean=500, sd=100 )
cdist( "chisq", c(.90, .95), df=3 )
# CI
x <- rnorm(23, mean = 10, sd = 2)
cdist("t", p = 0.95, df=22)
mean(x) + cdist("t", p = 0.95, df=22) * sd(x) / sqrt(23)
confint(t.test(x))
cdist("t", p = 0.95, df=22, verbose = TRUE)
}
