% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpnorm.R
\name{xpnorm}
\alias{xpnorm}
\alias{xqnorm}
\title{Augmented versions of pnorm and qnorm}
\usage{
xpnorm(q, mean = 0, sd = 1, plot = TRUE, verbose = TRUE,
  invisible = FALSE, digits = 4, lower.tail = TRUE, log.p = FALSE,
  xlim = mean + c(-4, 4) * sd, ylim = c(0, 1.4 * dnorm(mean, mean, sd)),
  vlwd = 2, vcol = trellis.par.get("add.line")$col, rot = 45,
  manipulate = FALSE, ...)

xqnorm(p, mean = 0, sd = 1, plot = TRUE, verbose = TRUE, digits = 4,
  lower.tail = TRUE, log.p = FALSE, xlim, ylim, invisible = FALSE,
  vlwd = 2, vcol = trellis.par.get("add.line")$col, rot = 45, ...)
}
\arguments{
\item{q}{quantile}

\item{mean, sd}{parameters of normal distribution.}

\item{plot}{logical.  If TRUE, show an illustrative plot.}

\item{verbose}{logical.  If TRUE, display verbose output.}

\item{invisible}{logical.  If TRUE, return value invisibly.}

\item{digits}{number of digits to display in output.}

\item{lower.tail}{logical.  If FALSE, use upper tail probabilities.}

\item{log.p}{logical.  If TRUE, uses the log of probabilities.}

\item{xlim, ylim}{limits for plotting.}

\item{vlwd, vcol}{line width and color for vertical lines.}

\item{rot}{angle of rotation for text labels.}

\item{manipulate}{logical.  If TRUE and in RStudio,
then sliders are added for interactivity.}

\item{p}{probability}

\item{\dots}{additional arguments.}
}
\description{
These functions behave similarly to the functions with the initial \code{x}
removed from their names but add more verbose output and graphics.
}
\examples{
xpnorm(650, 500, 100)
xqnorm(.75, 500, 100)
\dontrun{
if (rstudio_is_available() & require(manipulate)) {
  manipulate(xpnorm(score, 500, 100, verbose=verbose),
    score = slider(200,800),
	   verbose = checkbox(TRUE, label="Verbose Output")
  )
}
}
}
\seealso{
\code{\link{histogram}}, 
\code{\link{chisq.test}}, 
\code{\link{pnorm}}, 
\code{\link{qnorm}}, 
\code{\link{qqmath}}, and
\code{\link{plot}}.
}

