% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.R
\name{tally}
\alias{tally}
\alias{tally_internal}
\alias{tally_internal.data.frame}
\alias{tally_internal.formula}
\alias{tally_internal.tbl}
\title{Tabulate categorical data}
\usage{
tally(x, ...)

tally_internal(x, ...)

\method{tally_internal}{tbl}(x, wt, sort = FALSE, ...,
  envir = parent.frame())

\method{tally_internal}{data.frame}(x, wt, sort = FALSE, ...,
  envir = parent.frame())

\method{tally_internal}{formula}(x, data = parent.frame(2),
  format = c("count", "proportion", "percent", "data.frame", "sparse",
  "default"), margins = FALSE, quiet = TRUE, subset, useNA = "ifany", ...)
}
\arguments{
\item{x}{an object}

\item{...}{additional arguments passed to \code{\link{table}}}

\item{wt}{for weighted tallying, 
see \code{\link[dplyr]{tally}} in \pkg{dplyr}}

\item{sort}{a logical, 
see \code{\link[dplyr]{tally}} in \pkg{dplyr}}

\item{envir}{an environment in which to evaluate}

\item{data}{a data frame or environment in which evaluation occurs.
Note that the default is \code{data=parent.frame()}.  This makes it convenient to
use this function interactively by treating the working envionment as if it were 
a data frame.  But this may not be appropriate for programming uses.  
When programming, it is best to use an explicit \code{data} argument
-- ideally supplying a data frame that contains the variables mentioned}

\item{format}{a character string describing the desired format of the results.
One of \code{'default'}, \code{'count'}, \code{'proportion'}, \code{'percent'}, 
\code{'data.frame'}, \code{'sparse'}, or \code{'default'}.
In case of \code{'default'}, counts are used unless there is a condition, in
which case proportions are used instead.  Note that prior to version 0.9.3, 
\code{'default'} was the default, now it is \code{'count'}.
\code{'data.frame'} converts the table to a data frame with one row per cell;
\code{'sparse'} additionally removes any rows with 0 counts.}

\item{margins}{a logical indicating whether marginal distributions should be displayed.}

\item{quiet}{a logical indicating whether messages about order in which 
marginal distributions are calculated should be surpressed.  
See \code{\link{addmargins}}.}

\item{subset}{an expression evaluating to a logical vector used to select a subset of \code{data}}

\item{useNA}{as in \code{\link{table}}, but the default here is \code{"ifany"}.}
}
\description{
Tabulate categorical data
}
\details{
The \pkg{dplyr} package also exports a \code{\link[dplyr]{tally}} function.  If \code{x} inherits 
from class \code{"tbl"}, then \pkg{dplyr}'s \code{tally} is called.  This makes it
easier to have the two package coexist.
}
\note{
The curent implementation when \code{format = "sparse"} first creates the full data frame
and then removes the unneeded rows.  So the savings is in terms of space, not time.
}
\examples{
if (require(mosaicData)) {
tally( ~ substance, data=HELPrct)
tally( ~ substance & sex , data=HELPrct)
tally( sex ~ substance, data=HELPrct)   # equivalent to tally( ~ sex | substance, ... )
tally( ~ substance | sex , data=HELPrct)
tally( ~ substance | sex , data=HELPrct, format='count')
tally( ~ substance & sex , data=HELPrct, format='percent')
# force NAs to show up
tally( ~ sex, data=HELPrct, useNA="always")
# show NAs if any are there
tally( ~ link, data=HELPrct)
# ignore the NAs
tally( ~ link, data=HELPrct, useNA="no")
}
}

