devtools::load_all()
m1 <- "
# Outer Model
  X =~ x1
  Z =~ z1 
  x1 ~~ 0.1 * x1
  Y =~ y1

# Inner model
  Y ~ a * X + a * Z
  Y ~~ Y
  Y ~ b * X:Z + 0.05 * X:X
  b == a * 1.2
"
# funnily enough, the starting parameters from the double centering approach
# give better loglikelihoods than the ones arrived at by the EM algorithm
# i.e., the loglikelihood decreases from the starting parameters
startTime1 <- Sys.time()
est1 <- modsem(m1, oneInt, 
  method = "lms",
  optimize = TRUE, verbose = TRUE,
  convergence = 1e-2,
)
duration1 <- Sys.time() - startTime1
plot_interaction("X", "Z", "Y", "X:Z", -3:3, c(-0.5, 0.5), est1)
print(summary(est1, adjusted.stat = TRUE))

# I have no clue why, but changing the ordering of how the interaction terms 
# are specified, ends up changing the number of iterations (and results ever 
# so slightly) -- even though the matrices are exactly the same. This can be 
# seen through the fact that the starting loglikelihoods are the same (if optimized) 
# indicating that the matrices are the same (i.e,. produce the same results, when
# given the same values). 
# Solution: slightly different results from lavaan, giving slightly different 
# starting parameters
tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  LATENT_VAR_ATT =~ a1 * att1 + a2 * att2 + att3 + att4 + att5
  SN =~ s1 * sn1 + sn2
  PBC =~ p1 * pbc1 + pbc2 + pbc3
  INT =~ i1 * int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Causal Relationsships
  INT ~ gamma_int_att * LATENT_VAR_ATT + b * SN + b * PBC
  BEH ~ 0.2 * INT + a * PBC
  BEH ~ PBC:INT
  gamma_int_att == a
  p1 == 1 
  a2 == 1
  s1 == 1 
  i1 == 1
"

covModel <- '
PBC ~ a * LATENT_VAR_ATT + a * SN
'

startTime2 <- Sys.time()
testthat::expect_warning({
  est2 <- modsem(tpb, TPB, 
                 method = "lms", optimize = TRUE, verbose = TRUE, 
                 convergence = 1, cov.syntax = covModel,
                 nodes = 16, robust.se = TRUE)
  }, regexp = "It is recommended .* between endogenous variables .*")
duration2 <- Sys.time() - startTime2
plot_interaction(x = "INT", z = "PBC", y = "BEH", vals_z = c(-0.5, 0.5), model = est2)
print(summary(est2, H0 = FALSE))
var_interactions(est2)
standardized_estimates(est2)
vcov(est2) 
modsem_inspect(est2) 
coef(est2)
coefficients(est2)


tpb2 <- ' 
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  ATT ~~ SN + PBC
  PBC ~~ SN 
  # Causal Relationsships
  INT ~ a * ATT + b * SN + c * PBC
  BEH ~ INT + PBC 
  BEH ~ INT:PBC  
'

testthat::expect_warning({
  modsem(tpb, TPB, method = "lms",
         convergence = 1000,
         nodes = 16, calc.se = FALSE)
  }, regexp = "It is recommended .* between exogenous and endogenous .*")
