% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize_output.R
\name{colorize_output}
\alias{colorize_output}
\title{Capture, colorise, and emit console text}
\usage{
colorize_output(
  expr,
  positive = MODSEM_COLORS$positive,
  negative = MODSEM_COLORS$negative,
  true = MODSEM_COLORS$true,
  false = MODSEM_COLORS$false,
  nan = MODSEM_COLORS$nan,
  na = MODSEM_COLORS$na,
  inf = MODSEM_COLORS$inf,
  string = MODSEM_COLORS$string,
  split = FALSE,
  append = "\\n"
)
}
\arguments{
\item{expr}{Expression or object with output which should be colorized.}

\item{positive}{color of positive numbers.}

\item{negative}{color of negative numbers.}

\item{true}{color of \code{TRUE}.}

\item{false}{color of \code{FALSE}.}

\item{nan}{color of \code{NaN}.}

\item{na}{color of \code{NA}.}

\item{inf}{color of \code{-Inf} and \code{Inf}.}

\item{string}{color of quoted strings.}

\item{split}{Should output be splitted? If \code{TRUE} the output is printed
normally (in real time) with no colorization, and the colored output is printed
after the code has finished executing.}

\item{append}{String appended after the colored output (default `\\n`).}
}
\value{
Invisibly returns the *plain* captured text.
}
\description{
Capture, colorise, and emit console text
}
\examples{
set_modsem_colors(positive = "red3",
                  negative = "red3",
                  true = "darkgreen",
                  false = "red3",
                  na = "purple",
                  string = "darkgreen")

m1 <- "
# Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3
# Inner Model
  Y ~ X + Z + X:Z
"

est <- modsem(m1, data = oneInt)
colorize_output(summary(est))
colorize_output(est) # same as colorize_output(print(est))
colorize_output(modsem_inspect(est, what = "coef"))

\dontrun{
colorize_output(split = TRUE, {
  # Get live (uncolored) output
  # And print colored output at the end of execution

  est_lms <- modsem(m1, data = oneInt, method = "lms")
  summary(est_lms)
})

colorize_output(modsem_inspect(est_lms))
}
}
