% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_pi.R
\name{get_pi_data}
\alias{get_pi_data}
\title{Get data with product indicators for different approaches}
\usage{
get_pi_data(model.syntax, data, method = "dblcent", match = FALSE, ...)
}
\arguments{
\item{model.syntax}{lavaan syntax}

\item{data}{data to create product indicators from}

\item{method}{method to use:
"rca" = residual centering approach,
"uca" = unconstrained approach,
"dblcent" = double centering approach,
"pind" = prod ind approach, with no constraints or centering,
"custom" = use parameters specified in the function call}

\item{match}{should product indicators be made using the match strategy}

\item{...}{arguments passed to other functions (e.g., modsem_pi)}
}
\value{
data.frame
}
\description{
get_pi_syntax is a function for creating the lavaan syntax used for estimating 
latent interaction models using one of the product indiactors in lavaan.
}
\examples{
library(modsem)
library(lavaan)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3
  
  # Inner model
  Y ~ X + Z + X:Z 
'
syntax <- get_pi_syntax(m1)
data <- get_pi_data(m1, oneInt)
est <- sem(syntax, data)
}
