% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_merge_observations.R
\name{ms_merge_observations}
\alias{ms_merge_observations}
\title{Merge the observations of modelStudio objects}
\usage{
ms_merge_observations(...)
}
\arguments{
\item{...}{\code{modelStudio} objects created with \code{modelStudio()}.}
}
\value{
An object of the \code{r2d3, htmlwidget, modelStudio} class.
}
\description{
This function merges local explanations from multiple \code{modelStudio} objects into one.
}
\examples{
\donttest{
library("DALEX")
library("modelStudio")

# fit a model
model_happiness <- glm(score ~., data = happiness_train)

# create an explainer for the model
explainer_happiness <- explain(model_happiness,
                               data = happiness_test,
                               y = happiness_test$score)

# make studios for the model
ms1 <- modelStudio(explainer_happiness,
                   N = 200,  B = 5)

ms2 <- modelStudio(explainer_happiness,
                   new_observation = head(happiness_test, 3),
                   N = 200,  B = 5)

# merge 
ms <- ms_merge_observations(ms1, ms2)
ms
}

}
\references{
\itemize{
  \item The input object is implemented in \href{https://modeloriented.github.io/DALEX/}{\bold{DALEX}}
  \item Feature Importance, Ceteris Paribus, Partial Dependence and Accumulated Dependence explanations
   are implemented in \href{https://modeloriented.github.io/ingredients/}{\bold{ingredients}}
  \item Break Down and Shapley Values explanations are implemented in
   \href{https://modeloriented.github.io/iBreakDown/}{\bold{iBreakDown}}
}
}
\seealso{
Vignettes: \href{https://modelstudio.drwhy.ai/articles/ms-r-python-examples.html}{\bold{modelStudio - R & Python examples}}
and \href{https://modelstudio.drwhy.ai/articles/ms-perks-features.html}{\bold{modelStudio - perks and features}}
}
