% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.SR}
\alias{test.SR}
\title{Szekely-Rizzo (energy) test}
\usage{
test.SR(data, MC.rep = 10000, alpha = 0.05, abb = 1e-08)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}

\item{abb}{Stop criterium.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}#' }
}
\description{
Performs the test of multivariate normality of Szekely and Rizzo (2005). Note that the scaled residuals use another scaling in the estimator of the covariance matrix!
}
\examples{
test.SR(MASS::mvrnorm(50,c(0,1),diag(1,2)),MC.rep=500)

}
\references{
Szekely, G., Rizzo, M. (2005), A new test for multivariate normality, J. Multiv. Anal., 93:58-80, \href{https://doi.org/10.1016/j.jmva.2003.12.002}{DOI}
}
\seealso{
\code{\link{SR}}
}
