% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.HJM}
\alias{test.HJM}
\title{Henze-Jimenes-Gamero-Meintanis test of multivariate normality}
\usage{
test.HJM(data, a = 1.5, MC.rep = 500, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{a}{positive numeric number (tuning parameter).}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value.}

\item{alpha}{level of significance of the test.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
}
}
\description{
Computes the test statistic of the Henze-Jimenes-Gamero-Meintanis test.
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.
}
\examples{
\donttest{test.HJM(MASS::mvrnorm(10,c(0,1),diag(1,2)),a=2.5,MC=100)}

}
\references{
Henze, N., Jimenes-Gamero, M.D., Meintanis, S.G. (2019), Characterizations of multinormality and corresponding tests of fit, including for GARCH models, Econometric Th., 35:510-546, \href{https://doi.org/10.1017/S0266466618000154}{DOI}.
}
\seealso{
\code{\link{HJM}}
}
