% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.BHEP}
\alias{test.BHEP}
\title{Baringhaus-Henze-Epps-Pulley (BHEP) test}
\usage{
test.BHEP(data, a = 1, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{a}{positive numeric number (tuning parameter).}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}#' }
}
\description{
Performs the BHEP test of multivariate normality as suggested in Henze and Wagner (1997) using a tuning parameter \code{a}.
}
\details{
The test statistic is \deqn{BHEP_{n,\beta}=\frac{1}{n} \sum_{j,k=1}^n \exp\left(-\frac{\beta^2\|Y_{n,j}-Y_{n,k}\|^2}{2}\right)- \frac{2}{(1+\beta^2)^{d/2}} \sum_{j=1}^n \exp\left(- \frac{\beta^2\|Y_{n,j}\|^2}{2(1+\beta^2)} \right) + \frac{n}{(1+2\beta^2)^{d/2}}.}
Here, \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{j=1,\ldots,n}, are the scaled residuals, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.
}
\examples{
test.BHEP(MASS::mvrnorm(50,c(0,1),diag(1,2)),MC.rep=500)

}
\references{
Henze, N., Wagner, T. (1997), A new approach to the class of BHEP tests for multivariate normality, J. Multiv. Anal., 62:1-23, \href{https://doi.org/10.1006/jmva.1997.1684}{DOI}
}
\seealso{
\code{\link{BHEP}}
}
